//
//  MCCoreDataManager.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 09-10-22.
//  Copyright 2009 Marketcircle Inc. All rights reserved.
//

#import <CoreData/CoreData.h>


@interface MCCoreDataManager : NSObject {
	
	NSURL *storeURL;
	BOOL storeUnreadable;
	BOOL readOnly;

	NSManagedObjectModel *model;
	NSPersistentStoreCoordinator *coordinator;
	NSManagedObjectContext *context;
}

- (void)setStoreURL:(NSURL *)newStoreURL;
- (NSURL *)storeURL;

- (BOOL)storeUnreadable;
- (void)setStoreUnreadable:(BOOL)aBool;

- (BOOL)readOnly;
- (void)setReadOnly:(BOOL)flag;

- (NSManagedObjectModel *)model;
- (NSPersistentStoreCoordinator *)coordinator;
- (NSManagedObjectContext *)context;

- (id)initWithStoreURL:(NSURL *)url;

- (BOOL)save;
- (void)refreshObjects:(NSArray *)objects;
- (void)deleteObject:(NSManagedObject *)object;

// convenience: objectURIs must contain string URLs (Not NSURLs)
- (void)refreshObjectsWithURIs:(NSArray *)objectURIs;


@end
